/*
 *  Copyright 2008 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  SWITCH header file
 *
 */

#include "dm388_types.h"

#ifndef SWITCH_
#define SWITCH_

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define CTRL_MODULE_BASE_ADDR     0x48140000
#define    PINCNTL41    (    CTRL_MODULE_BASE_ADDR +    0x08A0    )
#define    PINCNTL42    (    CTRL_MODULE_BASE_ADDR +    0x08A4    )
#define    PINCNTL232   (    CTRL_MODULE_BASE_ADDR +    0x0B9C    )

#define TRUE 1
#define FALSE 0
/* ------------------------------------------------------------------------ *
 *  SWITCH DEFINITIONS                                                      *
 * ------------------------------------------------------------------------ */
typedef enum
{
SWITCH_0 = 5,
SWITCH_1,
SWITCH_2,
SWITCH_3,
}key;
//#define SWITCH_0  5
//#define SWITCH_1  6
//#define SWITCH_2  7
//#define SWITCH_3  8

extern INT32 switch_test(void *testargs);
extern UINT16 switch_init();
extern void switch_get_press();

#endif
